### 参数说明

模块配置一共有16个参数，有3个配置参数为通道共用，分别是Sensor Type、Filter Type、Temp Mode；有4个配置参数可独立设置，分别是Cold Compensation、Filter Time、Enable、Cmp，以通道0为例介绍配置参数，如下表所示。

| **功能** | **参数名** | **取值范围** | **默认值** |
|---|---|---|---|
| 传感器类型选择 | Sensor Type | 0：PT100 | 0 |
| 1：PT200 |
| 2：PT500 |
| 3：PT1000 |
| 4：Ni120\_ID（Reserve） |
| 5：THERMOCOUPLE\_K |
| 6：THERMOCOUPLE\_J |
| 7：THERMOCOUPLE\_T（Reserve） |
| 8：THERMOCOUPLE\_E |
| 9：THERMOCOUPLE\_N（Reserve） |
| 10：THERMOCOUPLE\_S |
| 11：THERMOCOUPLE\_R（Reserve） |
| 12：THERMOCOUPLE\_B |
| 13：THERMOCOUPLE\_C（Reserve） |
| 14：THERMOCOUPLE\_L（Reserve） |
| 15：THERMOCOUPLE\_U（Reserve） |
| 16：Ni 100 |
| 17：Ni 1000 |
| 18：LG-Ni 1000（Reserve） |
| 19：Ni 200（Reserve） |
| 20：Ni 500（Reserve） |
| 21：RESISTANCE\_15:150（Reserve） |
| 22：RESISTANCE\_15:300（Reserve） |
| 23：RESISTANCE\_15:600（Reserve） |
| 24：RESISTANCE\_15:3000 |
| 25：-1 : 1V（Reserve） |
| 26：-250 : 250mV（Reserve） |
| 27：-50：50mV（Reserve） |
| 28：-80 : 80mV（Reserve） |
| 滤波类型 | Filter Type | 0：Default | 0 |
| 50hz |
| 60hz |
| 10hz |
| 冷端补偿功能 | Cold Compensation | 0~65535 | 0（默认开启） |
| 温度测量单位切换 | Temp Mode | Centigrade | 0 |
| Fahrenheit |
| Thermodynamic |
| 通道滤波时间 | Channel0 Filter Time | 0~10 | 0 |
| 通道使能 | Channel0 Enable | Disable | 1 |
| Enable |
| 温度补偿 | Channel0 Cmp | -10000~10000 | 0 |

---

### 传感器类型选择

模块支持传感器类型配置功能

同一模块只支持同时配置同一类型传感器，单个通道不可配置。

备注：默认传感器类型为PT100。

---

### 滤波功能

模块提供无滤波、50Hz、60Hz、10Hz硬件滤波配置功能。

单个通道可通过通道滤波功能对各个测量值进行滤波，通过对前N次采集数据进行滑动平均处理，以减小测量值的抖动范围，提高了稳定性和精度。

滤波时间=模块周期数(N)×模块循环时间

模块循环时间 = 转换时间+断连检测时间

备注：N配置范围0~10。

---

### 冷端补偿功能

模块支持热电偶冷端补偿功能开启或关闭，默认全部开启，可支持单通道配置，4个通道共8位，每个通道占用2位，设置00则该通道开启冷端补偿功能，设置01则通道关闭冷端补偿功能。

---

### 温度测量单位切换

模块支持温度测量单位在摄氏度（Centigrade）、华氏度（Fahrenheit）、热力学温标（Thermodynamic）之间的配置转换。

备注：默认传感器类型为摄氏度（Centigrade）。

---

### 通道使能功能

模块可通过“使能/不使能”参数设置，来确定通道是否使用。如通道设置为不使能，则此通道被禁用，无论是否接入传感器，均无显示-9999。

备注：通道默认设置为使能。

---

### 温度补偿功能

模块支持热电偶和热电阻模式下为每个通道数据的手动冷端补偿功能，可根据实际需要输入数据补偿值。设置补偿值后，将在上行数据（Input）中自动计算补偿后的温度，即上行数据为最终的补偿后的温度。将读出的数据除以10，即为补偿后的温度，单位为℃。

---